import { STRUCTURED_CLONE_OBJECT_PROTOTYPE } from "@tldraw/utils";
function devFreeze(object) {
  if (process.env.NODE_ENV === "production") {
    return object;
  }
  const proto = Object.getPrototypeOf(object);
  if (proto && !(Array.isArray(object) || proto === Object.prototype || proto === null || proto === STRUCTURED_CLONE_OBJECT_PROTOTYPE)) {
    console.error("cannot include non-js data in a record", object);
    throw new Error("cannot include non-js data in a record");
  }
  const propNames = Object.getOwnPropertyNames(object);
  for (const name of propNames) {
    const value = object[name];
    if (value && typeof value === "object") {
      devFreeze(value);
    }
  }
  return Object.freeze(object);
}
export {
  devFreeze
};
//# sourceMappingURL=devFreeze.mjs.map
